package com.app.yourradioapp593.activities;

import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.widget.Button;
import android.widget.ImageButton;

import androidx.activity.OnBackPressedCallback;
import androidx.activity.OnBackPressedDispatcher;
import androidx.appcompat.app.AppCompatActivity;
import androidx.core.content.ContextCompat;

import com.app.yourradioapp593.Config;
import com.app.yourradioapp593.R;
import com.app.yourradioapp593.database.prefs.SharedPref;
import com.app.yourradioapp593.utils.Constant;
import com.app.yourradioapp593.utils.Tools;
import com.google.android.material.snackbar.Snackbar;
import com.solodroidx.ads.appopen.AppOpenAd;

public class ActivityRedirect extends AppCompatActivity {

    ImageButton btnClose;
    Button btnRedirect;
    String redirectUrl = "";
    OnBackPressedDispatcher onBackPressedDispatcher;
    SharedPref sharedPref;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Tools.getTheme(this);
        setContentView(R.layout.activity_redirect);
        Tools.setNavigation(this);
        sharedPref = new SharedPref(this);
        redirectUrl = getIntent().getStringExtra("redirect_url");
        initView();
        setStatusBar();
//        setBackgroundColor();
        handleOnBackPressed();
    }


    public void handleOnBackPressed() {
        onBackPressedDispatcher = getOnBackPressedDispatcher();
        onBackPressedDispatcher.addCallback(this, new OnBackPressedCallback(true) {
            @Override
            public void handleOnBackPressed() {
                finish();
                AppOpenAd.isAppOpenAdLoaded = false;
            }
        });
    }

    private void initView() {
        btnClose = findViewById(R.id.btn_close);
        btnRedirect = findViewById(R.id.btn_redirect);

        btnClose.setOnClickListener(view -> {
            finish();
            AppOpenAd.isAppOpenAdLoaded = false;
        });

        btnRedirect.setOnClickListener(view -> {
            if (redirectUrl.equals("")) {
                Snackbar.make(findViewById(android.R.id.content), getString(R.string.redirect_error), Snackbar.LENGTH_SHORT).show();
            } else {
                startActivity(new Intent(Intent.ACTION_VIEW, Uri.parse(redirectUrl)));
                finish();
                AppOpenAd.isAppOpenAdLoaded = false;
            }
        });
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        AppOpenAd.isAppOpenAdLoaded = false;
        Constant.isRadioPlaying = false;
    }

    private void setStatusBar() {
        if (sharedPref.getIsDarkTheme()) {
            Tools.setStatusBarColor(this, findViewById(R.id.root_view), ContextCompat.getColor(this, R.color.color_dark_status_bar));
        } else {
            if (Config.ENABLE_NEW_UI) {
                Tools.setStatusBarColor(this, findViewById(R.id.root_view), ContextCompat.getColor(this, R.color.color_white));
            } else {
                Tools.setStatusBarColor(this, findViewById(R.id.root_view), ContextCompat.getColor(this, R.color.color_light_status_bar));
            }
        }
    }

//    private void setBackgroundColor() {
//        if (sharedPref.getIsDarkTheme()) {
//            findViewById(R.id.background_view).setBackgroundColor(ContextCompat.getColor(this, R.color.color_dark_background));
//        } else {
//            findViewById(R.id.background_view).setBackgroundColor(ContextCompat.getColor(this, R.color.color_light_background));
//        }
//    }

}
